/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Installer {
    private static boolean stackTraceMode = false;
    private static boolean optMode = false;
    private static boolean opt2Mode = false;
    private static boolean usrlocalMode = false;
    private static boolean posixMode = false;
    private static boolean windowsMode = false;
    private static UserPrincipal owner = null;
    private static GroupPrincipal group = null;
    private static boolean CLEANUP_BZDIR_ON_ERROR = false;
    private static boolean notDryrun = true;
    private static boolean dryrun = false;
    private static boolean deleteRootOnFailure = false;
    private static String rootName = null;
    private static Path root = null;
    private static Path bzdir = null;
    private static Path old = null;
    private static String tsname = null;
    private static Path tspath = null;
    private static boolean windowsOS = System.getProperty("os.name").replaceAll("\\s", "").startsWith("Windows");
    private static JRadioButton ulButton = null;
    private static JRadioButton optButton = null;
    private static JRadioButton opt2Button = null;
    private static JCheckBox gzipManCheckBox = null;
    private static String ourCodebase;

    private static void createDir(Path path, Set<PosixFilePermission> set) throws IOException {
        if (dryrun) {
            System.out.println("would create " + String.valueOf(path));
        }
        if (set == null) {
            if (notDryrun) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        } else if (notDryrun) {
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(set));
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView != null) {
                if (owner != null) {
                    posixFileAttributeView.setOwner(owner);
                }
                if (group != null) {
                    posixFileAttributeView.setGroup(group);
                }
                posixFileAttributeView.setPermissions(set);
            }
        }
    }

    private static Path createDirs(Path path, Path path2, Set<PosixFilePermission> set) throws IOException {
        Path path3 = path.resolve(path2);
        if (dryrun) {
            System.out.println("would create " + String.valueOf(path3));
        } else if (set == null) {
            Files.createDirectories(path3, new FileAttribute[0]);
        } else {
            Files.createDirectories(path3, PosixFilePermissions.asFileAttribute(set));
            int n = path3.getNameCount();
            for (int i = path.getNameCount(); i < n; ++i) {
                PosixFileAttributeView posixFileAttributeView;
                Path path4 = path3.subpath(0, i);
                if (path.isAbsolute()) {
                    path4 = path.getRoot().resolve(path4);
                }
                if ((posixFileAttributeView = Files.getFileAttributeView(path4, PosixFileAttributeView.class, new LinkOption[0])) == null) continue;
                if (owner != null) {
                    posixFileAttributeView.setOwner(owner);
                }
                if (group != null) {
                    posixFileAttributeView.setGroup(group);
                }
                posixFileAttributeView.setPermissions(set);
            }
        }
        return path3;
    }

    private static void createFile(Path path, Path path2, Set<PosixFilePermission> set, Set<PosixFilePermission> set2, InputStream inputStream) throws IOException {
        Path path3;
        Object object;
        Path path4 = path2.getFileName();
        String string = path4.toString();
        int n = string.lastIndexOf(46);
        String string2 = null;
        string2 = string.substring(n + 1);
        boolean bl = false;
        if (string2.equals("html") || string2.equals("txt") || string2.equals("css") || string2.equals("package-list") || string2.equals("policy") || string2.equals("conf") || string2.equals("cmd") || string2.equals("sh") || string2.equals("java") || string2.equals("js") || string2.equals("1") || string2.equals("5") || string2.equals("changelog") || string2.equals("copyright")) {
            bl = true;
        }
        if (path4 == null) {
            throw new IOException("empty path");
        }
        if (path2.getNameCount() > 1) {
            object = path2.getParent();
            path3 = Installer.createDirs(path, (Path)object, set);
        } else {
            path3 = path;
            if (!Files.isDirectory(path3, new LinkOption[0])) {
                Installer.createDir(path3, set);
            }
        }
        path3 = path3.resolve(path4);
        if (notDryrun) {
            if (set2 == null) {
                Files.createFile(path3, new FileAttribute[0]);
            } else {
                Files.createFile(path3, PosixFilePermissions.asFileAttribute(set2));
            }
            object = Files.getFileAttributeView(path3, PosixFileAttributeView.class, new LinkOption[0]);
            if (object != null) {
                if (owner != null) {
                    object.setOwner(owner);
                }
                if (group != null) {
                    object.setGroup(group);
                }
            }
        } else {
            System.out.println("would create file " + String.valueOf(path3));
        }
        if (notDryrun) {
            if (windowsOS && bl) {
                object = new InputStreamReader(inputStream, "UTF-8");
                LineNumberReader lineNumberReader = new LineNumberReader((Reader)object);
                PrintWriter printWriter = new PrintWriter(path3.toFile(), "UTF-8");
                String string3 = null;
                while ((string3 = lineNumberReader.readLine()) != null) {
                    printWriter.println(string3);
                }
                printWriter.flush();
                printWriter.close();
            } else {
                Files.copy(inputStream, path3, StandardCopyOption.REPLACE_EXISTING);
            }
            object = Files.getFileAttributeView(path3, PosixFileAttributeView.class, new LinkOption[0]);
            if (object != null) {
                if (owner != null) {
                    object.setOwner(owner);
                }
                if (group != null) {
                    object.setGroup(group);
                }
                object.setPermissions(set2);
            }
        }
    }

    private static void createLink(Path path, Path path2, boolean bl) throws IOException {
        Path path3 = path.getParent();
        Path path4 = path.getFileName();
        if (Files.isSymbolicLink(path3)) {
            int n = 0;
            while (Files.isSymbolicLink(path3)) {
                path3 = path3.resolveSibling(Files.readSymbolicLink(path3));
                if (++n <= 256) continue;
                throw new IOException("Too many symbolic links: " + String.valueOf(path));
            }
            path = path3.resolve(path4);
        }
        if (bl) {
            path2 = path.getParent().relativize(path2);
        }
        if (notDryrun) {
            Files.createSymbolicLink(path, path2, new FileAttribute[0]);
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            if (posixFileAttributeView != null) {
                if (owner != null) {
                    posixFileAttributeView.setOwner(owner);
                }
                if (group != null) {
                    posixFileAttributeView.setGroup(group);
                }
            }
        } else {
            System.out.println("would link " + String.valueOf(path) + " to " + String.valueOf(path2));
        }
    }

    private static void unzip(FileSystem fileSystem, Path path, String string, Set<PosixFilePermission> set, Set<PosixFilePermission> set2) throws IOException {
        ZipEntry zipEntry;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        String string2 = fileSystem.getSeparator();
        String string3 = Matcher.quoteReplacement(string2);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Path path2 = fileSystem.getPath(zipEntry.getName().replaceAll("/", string3), new String[0]);
            if (notDryrun) {
                Installer.createFile(path, path2, set, set2, zipInputStream);
            } else {
                Path path3 = path.resolve(path2);
                System.out.println("would create " + String.valueOf(path3));
                zipInputStream.skip(zipEntry.getSize());
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }

    private static void clearDirectory(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            for (Path path2 : Files.newDirectoryStream(path)) {
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    Installer.clearDirectory(path2);
                }
                if (notDryrun) {
                    Files.delete(path2);
                    continue;
                }
                System.out.println("would delete " + String.valueOf(path2));
            }
        }
    }

    static void cleanupOnError() {
        if (notDryrun && old != null && Files.isDirectory(old, new LinkOption[0]) && Files.isDirectory(bzdir, new LinkOption[0])) {
            try {
                Installer.clearDirectory(bzdir);
                Files.delete(bzdir);
                Files.move(old, bzdir, new CopyOption[0]);
            }
            catch (IOException iOException) {
                System.out.println("restoration of old directory failed");
            }
        }
        if (deleteRootOnFailure && root != null) {
            if (CLEANUP_BZDIR_ON_ERROR && Files.isDirectory(bzdir, new LinkOption[0])) {
                try {
                    Installer.clearDirectory(bzdir);
                    Files.delete(bzdir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                Files.deleteIfExists(root);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void installInteractively() {
        JComponent jComponent;
        Object object;
        FileSystem fileSystem = FileSystems.getDefault();
        JFrame jFrame = new JFrame("Installer");
        jFrame.setLocationRelativeTo(null);
        Container container = jFrame.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        container.setLayout(gridBagLayout);
        String string = "install in /opt";
        String string2 = "install in /opt & configure /opt/bin  /opt/man/*";
        String string3 = "install in /usr/local";
        String string4 = "gzip man pages";
        String string5 = "no API documentation";
        String string6 = "Uninstall";
        String string7 = "dry run";
        String string8 = "run";
        final boolean bl = windowsOS;
        if (windowsOS) {
            Object object2 = System.getenv("PROGRAMDATA");
            if (object2 == null) {
                JOptionPane.showMessageDialog(null, "Cannot find installation directory - %PROGRAMDATA% missing", "Bzdev Installer Error", 0);
                System.exit(1);
            } else {
                object2 = "%PROGRAMDATA%" + fileSystem.getSeparator() + "bzdev";
            }
            object = new JLabel("Install into directory");
            jComponent = new JLabel((String)object2);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            container.add((Component)object);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            container.add(jComponent);
        } else {
            ulButton = new JRadioButton(string3);
            optButton = new JRadioButton(string);
            opt2Button = new JRadioButton(string2);
            gzipManCheckBox = new JCheckBox(string4);
            gzipManCheckBox.setSelected(false);
            boolean bl2 = true;
            if (Files.isDirectory(fileSystem.getPath("/usr/local/share/bzdev", new String[0]), new LinkOption[0])) {
                ulButton.setSelected(true);
                object = fileSystem.getPath("/usr/local/share/bzdev/man/man1/lsnof.1.gz", new String[0]);
                if (Files.exists((Path)object, new LinkOption[0])) {
                    gzipManCheckBox.setSelected(true);
                }
            } else if (Files.isDirectory(fileSystem.getPath("/opt/bzdev", new String[0]), new LinkOption[0])) {
                if (Files.isDirectory(fileSystem.getPath("/opt/bin", new String[0]), new LinkOption[0])) {
                    opt2Button.setSelected(true);
                } else {
                    optButton.setSelected(true);
                }
                object = fileSystem.getPath("/opt/bzdev/man/man1/lsnof.1.gz", new String[0]);
                if (Files.exists((Path)object, new LinkOption[0])) {
                    gzipManCheckBox.setSelected(true);
                }
            } else {
                ulButton.setSelected(true);
                bl2 = false;
            }
            object = new ButtonGroup();
            ((ButtonGroup)object).add(ulButton);
            ((ButtonGroup)object).add(optButton);
            ((ButtonGroup)object).add(opt2Button);
            if (bl2) {
                if (ulButton.isSelected()) {
                    optButton.setEnabled(false);
                    opt2Button.setEnabled(false);
                } else {
                    ulButton.setEnabled(false);
                }
            }
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(ulButton, gridBagConstraints);
            container.add(ulButton);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(optButton, gridBagConstraints);
            container.add(optButton);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(opt2Button, gridBagConstraints);
            container.add(opt2Button);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(gzipManCheckBox, gridBagConstraints);
            container.add(gzipManCheckBox);
        }
        final JCheckBox jCheckBox = new JCheckBox(string5);
        jCheckBox.setSelected(false);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
        container.add(jCheckBox);
        object = new JCheckBox(string6);
        ((AbstractButton)object).setSelected(false);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        container.add((Component)object);
        jComponent = new JCheckBox(string7);
        ((AbstractButton)jComponent).setSelected(false);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        container.add(jComponent);
        JButton jButton = new JButton(string8);
        jButton.addActionListener(new AbstractAction((JCheckBox)object, fileSystem, jFrame, (JCheckBox)jComponent){
            final /* synthetic */ JCheckBox val$uninstallCheckBox;
            final /* synthetic */ FileSystem val$fs;
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JCheckBox val$dryrunCheckBox;
            {
                this.val$uninstallCheckBox = jCheckBox2;
                this.val$fs = fileSystem;
                this.val$frame = jFrame;
                this.val$dryrunCheckBox = jCheckBox3;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (bl) {
                    arrayList.add("--windows");
                } else {
                    if (ulButton.isSelected()) {
                        arrayList.add("--usrlocal");
                    }
                    if (optButton.isSelected()) {
                        arrayList.add("--opt");
                    }
                    if (opt2Button.isSelected()) {
                        arrayList.add("--opt2");
                    }
                    if (gzipManCheckBox.isSelected()) {
                        arrayList.add("--gzipManPages");
                    }
                }
                if (jCheckBox.isSelected()) {
                    arrayList.add("--minimal");
                }
                if (this.val$uninstallCheckBox.isSelected()) {
                    arrayList.add("--uninstall");
                    if (!bl && ulButton.isSelected() && !Files.isDirectory(this.val$fs.getPath("/usr/local/share/bzdev", new String[0]), new LinkOption[0])) {
                        JOptionPane.showMessageDialog(this.val$frame, "not installed in /usr/local", "Bzdev Installer Error", 0);
                        return;
                    }
                    if (!bl && (optButton.isSelected() || opt2Button.isSelected())) {
                        if (!Files.isDirectory(this.val$fs.getPath("/opt/bzdev", new String[0]), new LinkOption[0])) {
                            JOptionPane.showMessageDialog(this.val$frame, "not installed in /opt", "Bzdev Installer Error", 0);
                            return;
                        }
                        if (opt2Button.isSelected() && !Files.exists(this.val$fs.getPath("/opt/bin/scrunner", new String[0]), new LinkOption[0])) {
                            JOptionPane.showMessageDialog(this.val$frame, "binaries not in /opt/bin", "Bzdev Installer Error", 0);
                            return;
                        }
                    }
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                if (this.val$dryrunCheckBox.isSelected()) {
                    String string = "java -jar " + ourCodebase;
                    for (String string2 : stringArray) {
                        string = string + " " + string2;
                    }
                    JTextField jTextField = new JTextField(string, string.length());
                    jTextField.setEditable(false);
                    JOptionPane.showMessageDialog(this.val$frame, jTextField, "Bzdev Installer Java Command", -1);
                    return;
                }
                try {
                    Installer.mainMethod(stringArray);
                    JOptionPane.showMessageDialog(this.val$frame, "Installer will exit - no errors detected", "Bzdev Installer", 1);
                    System.exit(0);
                }
                catch (Exception exception) {
                    Installer.cleanupOnError();
                    JOptionPane.showMessageDialog(this.val$frame, exception.getMessage(), "Bzdev Installer Error", 0);
                    System.exit(1);
                }
                catch (Error error) {
                    Installer.cleanupOnError();
                    JOptionPane.showMessageDialog(this.val$frame, error.getMessage(), "Bzdev Installer Error", 0);
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(this.val$frame, throwable.getMessage(), "Bzdev Installer Error", 0);
                    System.exit(1);
                }
            }
        });
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        container.add(jButton);
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            SwingUtilities.invokeLater(() -> Installer.installInteractively());
        } else {
            try {
                Installer.mainMethod(stringArray);
            }
            catch (Exception exception) {
                if (stackTraceMode) {
                    exception.printStackTrace(System.out);
                } else {
                    System.out.print(exception.getClass().getName() + ": ");
                    System.out.println(exception.getMessage());
                }
                Installer.cleanupOnError();
                System.exit(1);
            }
            catch (Error error) {
                if (stackTraceMode) {
                    error.printStackTrace(System.out);
                } else {
                    System.out.print(error.getClass().getName() + ": ");
                    System.out.println(error.getMessage());
                }
                Installer.cleanupOnError();
                System.exit(1);
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
                System.exit(1);
            }
            System.exit(0);
        }
    }

    private static void mainMethod(String[] stringArray) throws Throwable {
        Object object;
        Object object2;
        Object object3;
        String string;
        int n;
        Object object4;
        Object object5;
        Object object6;
        PosixFileAttributeView posixFileAttributeView;
        Object object7;
        Object object8;
        Path path2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        String string2 = "java";
        String string3 = "javaw";
        boolean bl5 = windowsOS;
        tsname = bl5 ? "timestamp.dat" : ".timestamp";
        String string4 = bl5 ? System.getenv("PROGRAMDATA") : null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--help") || stringArray[i].equals("-?")) {
                System.out.println("installer options: ");
                System.out.println(" --opt");
                System.out.println("        Install into /opt (for Unix/Linux)");
                System.out.println(" --opt2");
                System.out.println("        Install into /opt and configure /opt/bin, /opt/man/man1, & opt/man/man5");
                System.out.println(" --usrlocal");
                System.out.println("        Install into /usr/local (for Unix/Linux)");
                System.out.println(" --windows");
                System.out.println("        set up the installation for Windows systems");
                System.out.println(" --rootdir DIRNAME");
                System.out.println("        use DIRNAME as the name of the root directory (e.g., for testing)");
                System.out.println(" --dryrun");
                System.out.println("        show what would be installed");
                System.out.println(" --gzipManPages");
                System.out.println("        gzip the man pages (Linux/Unix)");
                System.out.println(" --minimal");
                System.out.println("        do not install API documentation, PDF files, or examples");
                System.out.println(" --noJavadocs");
                System.out.println("        do not install API documentation");
                System.out.println(" --noPDFs");
                System.out.println("        do not install PDF files & examples");
                System.out.println(" --java COMMAND_NAME");
                System.out.println("        the name of the java command to use in shell scripts");
                System.out.println(" --javaw COMMAND_NAME");
                System.out.println("        the name of the javaw command to use in batch files");
                System.out.println(" --stacktrace");
                System.out.println("        make the installer print a stacktrace if an error occurs");
                System.out.println(" --uninstall");
                System.out.println("        uninstall the software");
                System.out.println(" --help");
                System.out.println("        print installer options");
                System.out.println(" -?");
                System.out.println("        print installer options");
                return;
            }
            if (stringArray[i].equals("--opt")) {
                optMode = true;
                posixMode = true;
                continue;
            }
            if (stringArray[i].equals("--opt2")) {
                optMode = true;
                opt2Mode = true;
                posixMode = true;
                continue;
            }
            if (stringArray[i].equals("--usrlocal")) {
                usrlocalMode = true;
                posixMode = true;
                continue;
            }
            if (stringArray[i].equals("--windows")) {
                windowsMode = true;
                continue;
            }
            if (stringArray[i].equals("--rootdir")) {
                if (++i < stringArray.length) {
                    rootName = stringArray[i];
                    continue;
                }
                throw new Throwable("missing argument for --rootdir");
            }
            if (stringArray[i].equals("--dryrun")) {
                notDryrun = false;
                dryrun = true;
                continue;
            }
            if (stringArray[i].equals("--gzipManPages")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--minimal")) {
                bl3 = false;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("--noPDFs")) {
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("--noJavadocs")) {
                bl3 = false;
                continue;
            }
            if (stringArray[i].equals("--java")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--javaw")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--stacktrace")) {
                stackTraceMode = true;
                continue;
            }
            if (stringArray[i].equals("--uninstall")) {
                bl4 = true;
                continue;
            }
            throw new Throwable("UnknownOption " + stringArray[i]);
        }
        FileSystem fileSystem = FileSystems.getDefault();
        Path path3 = path2 = string4 != null ? fileSystem.getPath(string4, new String[0]) : null;
        if (rootName != null) {
            path2 = path2 != null ? path2.subpath(0, path2.getNameCount()) : fileSystem.getPath("PROGRAMDATA", new String[0]);
        }
        Path path4 = fileSystem.getPath(System.getProperty("java.home"), new String[0]);
        Path path5 = root = rootName != null ? fileSystem.getPath(rootName, new String[0]) : path4.getRoot();
        if (rootName != null) {
            if (Files.exists(root, new LinkOption[0])) {
                if (!Files.isDirectory(root, new LinkOption[0])) {
                    throw new Throwable(rootName + " is not a directory");
                }
                if (!Files.isWritable(root)) {
                    throw new Throwable(rootName + " cannot be modified");
                }
            } else {
                Files.createDirectory(root, new FileAttribute[0]);
                deleteRootOnFailure = true;
            }
        }
        if (dryrun) {
            System.out.println("root directory = " + String.valueOf(root));
        }
        HashMap hashMap = new HashMap();
        String[] stringArray2 = new String[]{"lsnof", "scrunner", "yrunner"};
        String[] stringArray3 = new String[]{"lsnof.cmd", "scrunner.cmd", "scrunnerw.cmd", "yrunner.cmd", "yrunnerw.cmd", "sbl.cmd", "sblw.cmd"};
        String[] stringArray4 = new String[]{};
        String[] stringArray5 = new String[]{"lsnof.html", "scrunner.html", "scrunner.conf.html"};
        String[] stringArray6 = new String[]{"libbzdev-base.jar", "libbzdev-dmethods.jar", "libbzdev-desktop.jar", "libbzdev-esp.jar", "libbzdev-graphics.jar", "libbzdev-math.jar", "libbzdev-obnaming.jar", "libbzdev-parmproc.jar", "libbzdev-devqsim.jar", "libbzdev-drama.jar", "libbzdev-anim2d.jar", "libbzdev-p3d.jar", "libbzdev-ejws.jar", "libbzdev.jar", "lsnof.jar", "scrunner.jar", "yrunner.jar", "sbl.jar", "share.zip", "finish.txt"};
        String[] stringArray7 = new String[]{"libbzdev.policy"};
        String[] stringArray8 = new String[]{"scrunner.conf"};
        String[] stringArray9 = new String[]{"scrunner.1", "lsnof.1", "yrunner.1", "sbl.1"};
        String[] stringArray10 = new String[]{"scrunner.conf.5", "yrunner.5", "sbl.5"};
        String[] stringArray11 = new String[]{"scrunner.1.gz", "lsnof.1.gz", "yrunner.1.gz", "sbl.1.gz"};
        String[] stringArray12 = new String[]{"scrunner.conf.5.gz", "yrunner.5.gz", "sbl.5.gz"};
        String[] stringArray13 = new String[]{"changelog", "copyright", "esp.el"};
        String[] stringArray14 = new String[]{"api", "examples"};
        UserPrincipalLookupService userPrincipalLookupService = null;
        try {
            userPrincipalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            object8 = userPrincipalLookupService.lookupPrincipalByName(System.getProperty("user.name"));
            if (!windowsOS && rootName == null) {
                object7 = null;
                object7 = userPrincipalLookupService.lookupPrincipalByName("root");
                if (notDryrun && !object8.equals(object7)) {
                    throw new Throwable("must run as root");
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        object8 = null;
        object7 = null;
        String string5 = null;
        Path path6 = null;
        Path path7 = null;
        Path path8 = null;
        Path path9 = null;
        Path path10 = null;
        Path path11 = null;
        Path path12 = null;
        Path path13 = null;
        Path path14 = null;
        Path path15 = null;
        Path path16 = null;
        Path path17 = null;
        if (windowsMode) {
            if (path2 == null) {
                throw new Throwable("Attempt to use --windows but system not recognized as a Windows system");
            }
            if (path2.isAbsolute()) {
                object8 = path2;
                object7 = "%PROGRAMDATA%";
            } else {
                object8 = root.resolve(path2);
            }
        } else if (optMode) {
            var43_44 = 0;
            object8 = root.resolve(Paths.get("opt", new String[0]));
            while (Files.isSymbolicLink((Path)object8)) {
                object8 = object8.resolveSibling(Files.readSymbolicLink((Path)object8));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(object8));
            }
            if (opt2Mode) {
                path14 = object8.resolve("bin");
                var43_44 = 0;
                while (Files.isSymbolicLink(path14)) {
                    path14 = path14.resolveSibling(Files.readSymbolicLink(path14));
                    if (++var43_44 <= 256) continue;
                    throw new IOException("too many symbolic links: " + String.valueOf(path14));
                }
                path15 = object8.resolve("man");
                var43_44 = 0;
                while (Files.isSymbolicLink(path15)) {
                    path15 = path15.resolveSibling(Files.readSymbolicLink(path15));
                    if (++var43_44 <= 256) continue;
                    throw new IOException("too many symbolic links: " + String.valueOf(path15));
                }
                path16 = path15.resolve("man1");
                var43_44 = 0;
                while (Files.isSymbolicLink(path16)) {
                    path16 = path16.resolveSibling(Files.readSymbolicLink(path16));
                    if (++var43_44 <= 256) continue;
                    throw new IOException("too many symbolic links: " + String.valueOf(path16));
                }
                path17 = path15.resolve("man5");
                var43_44 = 0;
                while (Files.isSymbolicLink(path17)) {
                    path17 = path17.resolveSibling(Files.readSymbolicLink(path17));
                    if (++var43_44 <= 256) continue;
                    throw new IOException("too many symbolic links: " + String.valueOf(path17));
                }
            }
        } else if (usrlocalMode) {
            var43_44 = 0;
            object8 = root.resolve("usr");
            while (Files.isSymbolicLink((Path)object8)) {
                object8 = object8.resolveSibling(Files.readSymbolicLink((Path)object8));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(object8));
            }
            object8 = object8.resolve("local");
            var43_44 = 0;
            while (Files.isSymbolicLink((Path)object8)) {
                object8 = object8.resolveSibling(Files.readSymbolicLink((Path)object8));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(object8));
            }
            path14 = object8.resolve("bin");
            var43_44 = 0;
            while (Files.isSymbolicLink(path14)) {
                path14 = path14.resolveSibling(Files.readSymbolicLink(path14));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(path14));
            }
            path15 = object8.resolve("man");
            var43_44 = 0;
            while (Files.isSymbolicLink(path15)) {
                path15 = path15.resolveSibling(Files.readSymbolicLink(path15));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(path15));
            }
            path16 = path15.resolve("man1");
            var43_44 = 0;
            while (Files.isSymbolicLink(path16)) {
                path16 = path16.resolveSibling(Files.readSymbolicLink(path16));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(path16));
            }
            path17 = path15.resolve("man5");
            var43_44 = 0;
            while (Files.isSymbolicLink(path17)) {
                path17 = path17.resolveSibling(Files.readSymbolicLink(path17));
                if (++var43_44 <= 256) continue;
                throw new IOException("too many symbolic links: " + String.valueOf(path17));
            }
        } else {
            if (deleteRootOnFailure) {
                Files.delete(root);
            }
            throw new Throwable("Missing option: either --windows, --opt, opt2, or --usrlocal");
        }
        Set<PosixFilePermission> set = null;
        Set<PosixFilePermission> set2 = null;
        Set<PosixFilePermission> set3 = null;
        PosixFileAttributeView posixFileAttributeView2 = posixFileAttributeView = Files.exists((Path)object8, new LinkOption[0]) ? Files.getFileAttributeView((Path)object8, PosixFileAttributeView.class, new LinkOption[0]) : Files.getFileAttributeView(root, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            owner = posixFileAttributes.owner();
            group = posixFileAttributes.group();
            set = PosixFilePermissions.fromString("rwxr-xr-x");
            set2 = PosixFilePermissions.fromString("rw-r--r--");
            set3 = PosixFilePermissions.fromString("rwxr-xr-x");
        }
        if (usrlocalMode) {
            bzdir = object8.resolve("share");
            boolean bl6 = false;
            while (Files.isSymbolicLink(bzdir)) {
                bzdir = bzdir.resolveSibling(Files.readSymbolicLink(bzdir));
            }
            bzdir = bzdir.resolve("bzdev");
        } else {
            bzdir = object8.resolve("bzdev");
        }
        if (object7 != null) {
            string5 = (String)object7 + System.getProperty("file.separator") + "bzdev";
        }
        Path path18 = bzdir.resolveSibling("bzdev-old");
        tspath = bzdir.resolve(tsname);
        path6 = bzdir.resolve("bin");
        if (posixMode) {
            if (optMode) {
                path7 = root.resolve(Paths.get("etc", "opt", "bzdev"));
            } else if (usrlocalMode) {
                path7 = object8.resolve(Paths.get("etc", "bzdev"));
            }
        } else {
            path7 = bzdir;
        }
        path8 = bzdir.resolve("doc");
        path9 = path8.resolve("api");
        path10 = path8.resolve("examples");
        if (posixMode) {
            path11 = bzdir.resolve("man");
            path12 = path11.resolve("man1");
            path13 = path11.resolve("man5");
        }
        if (bl4 || Files.isDirectory(bzdir, new LinkOption[0]) && Files.exists(tspath, new LinkOption[0])) {
            if (Files.isDirectory(path18, new LinkOption[0])) {
                Installer.clearDirectory(path18);
                if (notDryrun) {
                    Files.delete(path18);
                } else {
                    System.out.println("would delete " + String.valueOf(old));
                }
            }
            if (Files.exists(path18, new LinkOption[0])) {
                throw new Throwable("File " + String.valueOf(old) + " exists and is not a directory or cannot be deleted");
            }
            if (bl4) {
                if (Files.isDirectory(bzdir, new LinkOption[0])) {
                    Path path19;
                    Path path20;
                    HashSet<String> hashSet = new HashSet<String>(2 * (stringArray6.length + stringArray7.length));
                    for (String string6 : stringArray6) {
                        hashSet.add(string6);
                    }
                    for (String string6 : stringArray7) {
                        hashSet.add(string6);
                    }
                    if (windowsMode) {
                        for (String string6 : stringArray8) {
                            hashSet.add(string6);
                        }
                    }
                    hashSet.add("bin");
                    hashSet.add("doc");
                    if (bl5) {
                        hashSet.add("timestamp.dat");
                    } else {
                        hashSet.add(".timestamp");
                    }
                    DirectoryStream.Filter<Path> filter = path -> {
                        String string = path.getFileName().toString();
                        return !hashSet.contains(string);
                    };
                    for (Path string9 : Files.newDirectoryStream(bzdir, filter)) {
                        System.out.println("Directory \"" + bzdir.toString() + "\" contains files created by other installers");
                        System.out.println("... found " + string9.getFileName().toString());
                        System.exit(1);
                    }
                    if (path14 != null && Files.isDirectory(path14, new LinkOption[0])) {
                        for (String string7 : stringArray2) {
                            path20 = path14.resolve(string7);
                            if (!Files.isSymbolicLink(path20)) continue;
                            path19 = path20.resolveSibling(Files.readSymbolicLink(path20)).normalize().getParent();
                            if (path19.equals(path6)) {
                                if (notDryrun) {
                                    Files.deleteIfExists(path20);
                                    continue;
                                }
                                System.out.println("would delete " + String.valueOf(path20));
                                continue;
                            }
                            System.out.println("Warning: could not delete " + String.valueOf(path20));
                        }
                    }
                    if (path16 != null && Files.isDirectory(path16, new LinkOption[0])) {
                        for (String string8 : stringArray9) {
                            path20 = path16.resolve(string8);
                            if (!Files.isSymbolicLink(path20) || !(path19 = path20.resolveSibling(Files.readSymbolicLink(path20)).normalize().getParent()).equals(path12)) continue;
                            if (notDryrun) {
                                Files.deleteIfExists(path20);
                                continue;
                            }
                            System.out.println("would delete " + String.valueOf(path20));
                        }
                        for (String string9 : stringArray11) {
                            path20 = path16.resolve(string9);
                            if (!Files.isSymbolicLink(path20) || !(path19 = path20.resolveSibling(Files.readSymbolicLink(path20)).normalize().getParent()).equals(path12)) continue;
                            if (notDryrun) {
                                Files.deleteIfExists(path20);
                                continue;
                            }
                            System.out.println("would delete " + String.valueOf(path20));
                        }
                    }
                    if (path17 != null && Files.isDirectory(path17, new LinkOption[0])) {
                        for (String string10 : stringArray10) {
                            path20 = path17.resolve(string10);
                            if (!Files.isSymbolicLink(path20) || !(path19 = path20.resolveSibling(Files.readSymbolicLink(path20)).normalize().getParent()).equals(path13)) continue;
                            if (notDryrun) {
                                Files.deleteIfExists(path20);
                                continue;
                            }
                            System.out.println("would delete " + String.valueOf(path20));
                        }
                        for (String string11 : stringArray12) {
                            path20 = path17.resolve(string11);
                            if (!Files.isSymbolicLink(path20)) continue;
                            path19 = path20.resolveSibling(Files.readSymbolicLink(path20)).normalize().getParent();
                            if (notDryrun) {
                                Files.deleteIfExists(path20);
                                continue;
                            }
                            System.out.println("would delete " + String.valueOf(path20));
                        }
                    }
                    if (path7 != null && Files.isDirectory(path7, new LinkOption[0])) {
                        for (String string12 : stringArray8) {
                            path20 = path7.resolve(string12);
                            if (notDryrun) {
                                Files.deleteIfExists(path20);
                            } else {
                                System.out.println("would delete " + String.valueOf(path20));
                            }
                            Files.deleteIfExists(path20);
                        }
                        int n2 = 0;
                        for (Path path21 : Files.newDirectoryStream(path7)) {
                            ++n2;
                        }
                        if (n2 == 0 && path7.getFileName().toString().equals("bzdev")) {
                            if (notDryrun) {
                                Files.deleteIfExists(path7);
                            } else {
                                System.out.println("would delete " + String.valueOf(path7));
                            }
                        } else if (dryrun) {
                            System.out.println("would delete " + String.valueOf(path7) + " if empty");
                        }
                    }
                    Installer.clearDirectory(bzdir);
                    if (notDryrun) {
                        Files.delete(bzdir);
                    }
                    return;
                }
                if (Files.exists(bzdir, new LinkOption[0])) {
                    throw new Throwable("File " + String.valueOf(bzdir) + " exists and is not a directory or cannot be deleted");
                }
            } else {
                try {
                    if (notDryrun) {
                        Files.move(bzdir, path18, new CopyOption[0]);
                    } else {
                        System.out.println("would move " + String.valueOf(bzdir) + " to " + String.valueOf(path18));
                    }
                    old = path18;
                }
                catch (Exception exception) {
                    throw new Throwable("could not move " + String.valueOf(bzdir) + " to " + String.valueOf(path18) + "(" + exception.getClass().getName() + ": " + exception.getMessage() + ")");
                }
            }
        }
        if (!Files.exists((Path)object8, new LinkOption[0])) {
            Installer.createDir((Path)object8, set);
        } else if (!Files.isDirectory((Path)object8, new LinkOption[0])) {
            throw new Throwable("Install path does not point to a directory: " + String.valueOf(object8));
        }
        if (!Files.exists(bzdir, new LinkOption[0])) {
            Installer.createDir(bzdir, set);
        } else if (!Files.isDirectory(bzdir, new LinkOption[0])) {
            System.out.println("Expected a directory: " + String.valueOf(bzdir));
            System.exit(1);
        }
        Installer.clearDirectory(bzdir);
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(path6);
        arrayList.add(path8);
        if (posixMode) {
            arrayList.add(path11);
            arrayList.add(path12);
            arrayList.add(path13);
        }
        arrayList.add(path10);
        arrayList.add(path9);
        if (path14 != null) {
            arrayList.add(path14);
        }
        if (path15 != null) {
            arrayList.add(path15);
        }
        if (path16 != null) {
            arrayList.add(path16);
        }
        if (path17 != null) {
            arrayList.add(path17);
        }
        Path[] pathArray = arrayList.toArray(new Path[arrayList.size()]);
        if (notDryrun) {
            for (Path path22 : pathArray) {
                if (Files.exists(path22, new LinkOption[0])) continue;
                Installer.createDir(path22, set);
            }
        } else {
            for (Path path23 : pathArray) {
                System.out.println("Would create directory " + String.valueOf(path23));
            }
        }
        if (posixMode) {
            for (String string13 : stringArray2) {
                object6 = ClassLoader.getSystemResourceAsStream((String)string13 + ".sh");
                if (object6 == null) {
                    throw new Exception("could not find resource " + (String)string13);
                }
                object5 = new InputStreamReader((InputStream)object6, "UTF-8");
                object4 = new char[1024];
                var57_136 = 0;
                n = 0;
                while ((var57_136 = ((InputStreamReader)object5).read((char[])object4, var57_136, ((char[])object4).length - var57_136)) > 0) {
                    n += var57_136;
                }
                ((InputStream)object6).close();
                string = new String((char[])object4, 0, n);
                string = string.replace("JAVA", string2);
                string = string.replace("BZDEVDIR", bzdir.toString());
                object3 = string.getBytes("UTF-8");
                object2 = new ByteArrayInputStream((byte[])object3);
                Installer.createFile(path6, fileSystem.getPath(string13, new String[0]), set, set3, (InputStream)object2);
                ((ByteArrayInputStream)object2).close();
            }
        } else {
            for (String string14 : stringArray3) {
                object6 = ClassLoader.getSystemResourceAsStream(string14);
                if (object6 == null) {
                    throw new Exception("could not find resource " + (String)string14);
                }
                object5 = new InputStreamReader((InputStream)object6, "UTF-8");
                object4 = new char[1024];
                var57_136 = 0;
                n = 0;
                while ((var57_136 = ((InputStreamReader)object5).read((char[])object4, var57_136, ((char[])object4).length - var57_136)) > 0) {
                    n += var57_136;
                }
                ((InputStream)object6).close();
                string = new String((char[])object4, 0, n);
                string = string.contains("JAVAW") ? string.replace("JAVAW", string3) : string.replace("JAVA", string2);
                string = string5 != null ? string.replace("BZDEVDIR", string5) : string.replace("BZDEVDIR", "\"" + bzdir.toString() + "\"");
                string = string.replace("/", System.getProperty("file.separator"));
                object3 = string.getBytes("UTF-8");
                object2 = new ByteArrayInputStream((byte[])object3);
                Installer.createFile(path6, fileSystem.getPath(string14, new String[0]), set, set3, (InputStream)object2);
                ((ByteArrayInputStream)object2).close();
            }
        }
        if (path14 != null) {
            for (String string15 : stringArray2) {
                object6 = path14.resolve(fileSystem.getPath(string15, new String[0]));
                object5 = path6.resolve(fileSystem.getPath(string15, new String[0]));
                object4 = object6.getParent().relativize((Path)object5);
                if (Files.isSymbolicLink((Path)object6)) {
                    Path path24 = Files.readSymbolicLink((Path)object6);
                    if (path24.equals(object4)) continue;
                    System.out.println("ignoring symbolic link " + String.valueOf(object6) + ": does not point to .../bzdev/bin/" + (String)string15);
                    continue;
                }
                Installer.createLink((Path)object6, (Path)object5, true);
            }
        }
        for (String string16 : stringArray7) {
            object6 = ClassLoader.getSystemResourceAsStream(string16);
            if (object6 == null) {
                throw new Exception("could not find resource " + (String)string16);
            }
            object5 = new InputStreamReader((InputStream)object6, "UTF-8");
            object4 = new char[1024];
            int n3 = 0;
            n = 0;
            while ((n3 = ((InputStreamReader)object5).read((char[])object4, n3, ((char[])object4).length - n3)) > 0) {
                n += n3;
            }
            ((InputStream)object6).close();
            string = new String((char[])object4, 0, n);
            object3 = bzdir.toUri().toString();
            if (object3.startsWith("file:")) {
                object3 = object3.substring(5);
            }
            if (object3.endsWith("/")) {
                object3 = object3.substring(0, object3.length() - 1);
            }
            if (object3.startsWith("///")) {
                object3 = object3.substring(2);
            } else if (object3.startsWith("//")) {
                object3 = object3.substring(1);
            }
            string = string.replace("LOCATION", (CharSequence)object3);
            if (!posixMode) {
                string = string.replace("\n", System.getProperty("line.separator"));
            }
            object2 = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
            Installer.createFile(bzdir, fileSystem.getPath(string16, new String[0]), set, set2, byteArrayInputStream);
            byteArrayInputStream.close();
        }
        for (String string17 : stringArray8) {
            object6 = ClassLoader.getSystemResourceAsStream(string17);
            if (object6 == null) {
                throw new Exception("could not find resource " + (String)string17);
            }
            object5 = new InputStreamReader((InputStream)object6, "UTF-8");
            object4 = new char[8192];
            int n4 = 0;
            n = 0;
            while ((n4 = ((InputStreamReader)object5).read((char[])object4, n4, ((char[])object4).length - n4)) > 0) {
                n += n4;
            }
            ((InputStream)object6).close();
            string = new String((char[])object4, 0, n);
            if (!posixMode) {
                string = string.replace("\n", System.getProperty("line.separator"));
            }
            object3 = string.getBytes("UTF-8");
            object2 = new ByteArrayInputStream((byte[])object3);
            Files.deleteIfExists(path7.resolve(string17));
            Installer.createFile(path7, fileSystem.getPath(string17, new String[0]), set, set2, (InputStream)object2);
            ((ByteArrayInputStream)object2).close();
        }
        for (String string18 : stringArray13) {
            object6 = ClassLoader.getSystemResourceAsStream(string18);
            if (object6 == null) {
                throw new Exception("could not find resource " + (String)string18);
            }
            object5 = new InputStreamReader((InputStream)object6, "UTF-8");
            object4 = new char[1024];
            int n5 = 0;
            n = 0;
            while ((n5 = ((InputStreamReader)object5).read((char[])object4, 0, ((char[])object4).length)) > 0) {
                n += n5;
            }
            ((InputStreamReader)object5).close();
            object6 = ClassLoader.getSystemResourceAsStream(string18);
            object5 = new InputStreamReader((InputStream)object6, "UTF-8");
            object4 = new char[n + 1];
            n5 = 0;
            n = 0;
            while ((n5 = ((InputStreamReader)object5).read((char[])object4, n5, ((char[])object4).length - n5)) > 0) {
                n += n5;
            }
            ((InputStreamReader)object5).close();
            string = new String((char[])object4, 0, n);
            string = string.replace("JAVA", "java");
            string = string.replace("BZDEVDIR", bzdir.toString());
            if (!posixMode) {
                string = string.replace("\n", System.getProperty("line.separator"));
            }
            object3 = string.getBytes("UTF-8");
            object2 = new ByteArrayInputStream((byte[])object3);
            Installer.createFile(path8, fileSystem.getPath(string18, new String[0]), set, set2, (InputStream)object2);
            ((ByteArrayInputStream)object2).close();
        }
        for (String string19 : stringArray6) {
            object6 = ClassLoader.getSystemResourceAsStream(string19);
            Installer.createFile(bzdir, fileSystem.getPath(string19, new String[0]), set, set2, (InputStream)object6);
            ((InputStream)object6).close();
        }
        if (posixMode) {
            if (bl) {
                for (String string20 : stringArray11) {
                    object6 = ClassLoader.getSystemResourceAsStream(string20);
                    Installer.createFile(path12, fileSystem.getPath(string20, new String[0]), set, set2, (InputStream)object6);
                    ((InputStream)object6).close();
                }
                for (String string21 : stringArray12) {
                    object6 = ClassLoader.getSystemResourceAsStream(string21);
                    Installer.createFile(path13, fileSystem.getPath(string21, new String[0]), set, set2, (InputStream)object6);
                    ((InputStream)object6).close();
                }
                if (path16 != null) {
                    for (String string22 : stringArray11) {
                        object6 = path16.resolve(fileSystem.getPath(string22, new String[0]));
                        object5 = path12.resolve(fileSystem.getPath(string22, new String[0]));
                        object4 = object6.getParent().relativize((Path)object5);
                        if (Files.isSymbolicLink((Path)object6)) {
                            Path path25 = Files.readSymbolicLink((Path)object6);
                            if (path25.equals(object4)) continue;
                            throw new Throwable("symbolic link " + String.valueOf(object6) + "does not point to .../bzdev/man/man1/" + (String)string22);
                        }
                        Installer.createLink((Path)object6, (Path)object5, true);
                    }
                }
                if (path17 != null) {
                    for (String string23 : stringArray12) {
                        object6 = path17.resolve(fileSystem.getPath(string23, new String[0]));
                        object5 = path13.resolve(fileSystem.getPath(string23, new String[0]));
                        object4 = object6.getParent().relativize((Path)object5);
                        if (Files.isSymbolicLink((Path)object6)) {
                            Path path26 = Files.readSymbolicLink((Path)object6);
                            if (path26.equals(object4)) continue;
                            throw new Throwable("symbolic link " + String.valueOf(object6) + "does not point to .../bzdev/man/man5/" + (String)string23);
                        }
                        Installer.createLink((Path)object6, (Path)object5, true);
                    }
                }
            } else {
                for (String string24 : stringArray9) {
                    object6 = ClassLoader.getSystemResourceAsStream(string24);
                    if (object6 == null) {
                        System.err.println("no resource for name = " + (String)string24);
                    }
                    Installer.createFile(path12, fileSystem.getPath(string24, new String[0]), set, set2, (InputStream)object6);
                    ((InputStream)object6).close();
                }
                for (String string25 : stringArray10) {
                    object6 = ClassLoader.getSystemResourceAsStream(string25);
                    Installer.createFile(path13, fileSystem.getPath(string25, new String[0]), set, set2, (InputStream)object6);
                    ((InputStream)object6).close();
                }
                if (path16 != null) {
                    for (String string26 : stringArray9) {
                        object6 = path16.resolve(fileSystem.getPath(string26, new String[0]));
                        object5 = path12.resolve(fileSystem.getPath(string26, new String[0]));
                        object4 = object6.getParent().relativize((Path)object5);
                        if (Files.isSymbolicLink((Path)object6)) {
                            Path path27 = Files.readSymbolicLink((Path)object6);
                            if (path27.equals(object4)) continue;
                            System.out.println("symbolic link " + String.valueOf(object6) + "does not point to .../bzdev/man/man1/" + (String)string26);
                            continue;
                        }
                        Installer.createLink((Path)object6, (Path)object5, true);
                    }
                }
                if (path17 != null) {
                    for (String string27 : stringArray10) {
                        object6 = path17.resolve(fileSystem.getPath(string27, new String[0]));
                        object5 = path13.resolve(fileSystem.getPath(string27, new String[0]));
                        object4 = object6.getParent().relativize((Path)object5);
                        if (Files.isSymbolicLink((Path)object6)) {
                            Path path28 = Files.readSymbolicLink((Path)object6);
                            if (path28.equals(object4)) continue;
                            System.out.println("symbolic link " + String.valueOf(object6) + "does not point to .../bzdev/man/man5/" + (String)string27);
                            continue;
                        }
                        Installer.createLink((Path)object6, (Path)object5, true);
                    }
                }
            }
        } else {
            for (String string28 : stringArray5) {
                object6 = ClassLoader.getSystemResourceAsStream(string28);
                Installer.createFile(path8, fileSystem.getPath(string28, new String[0]), set, set2, (InputStream)object6);
                ((InputStream)object6).close();
            }
        }
        if (bl2) {
            for (String string29 : stringArray4) {
                object6 = ClassLoader.getSystemResourceAsStream(string29);
                Installer.createFile(path8, fileSystem.getPath(string29, new String[0]), set, set2, (InputStream)object6);
                ((InputStream)object6).close();
            }
            object = "examples";
            String string30 = "examples.zip";
            Path path29 = path8.resolve(fileSystem.getPath((String)object, new String[0]));
            Installer.unzip(fileSystem, path29, string30, set, set2);
        }
        if (bl3) {
            object = "api";
            String string31 = "api.zip";
            Path path30 = path8.resolve(fileSystem.getPath((String)object, new String[0]));
            Installer.unzip(fileSystem, path30, string31, set, set2);
        }
        if (!dryrun) {
            Files.createFile(tspath, new FileAttribute[0]);
            if (bl5) {
                object = Files.getFileAttributeView(tspath, DosFileAttributeView.class, new LinkOption[0]);
                if (object != null) {
                    object.setHidden(true);
                }
            } else {
                object = Files.getFileAttributeView(tspath, PosixFileAttributeView.class, new LinkOption[0]);
                if (object != null) {
                    if (owner != null) {
                        object.setOwner(owner);
                    }
                    if (group != null) {
                        object.setGroup(group);
                    }
                    object.setPermissions(set2);
                }
            }
        }
        if (dryrun && deleteRootOnFailure) {
            Files.deleteIfExists(root);
        }
        if (notDryrun && old != null && Files.isDirectory(old, new LinkOption[0])) {
            try {
                Installer.clearDirectory(old);
                Files.delete(old);
            }
            catch (IOException iOException) {
                throw new Throwable("cleanup of old directory failed");
            }
        }
    }

    static {
        try {
            ourCodebase = new File(Installer.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalFile().getCanonicalPath();
        }
        catch (Exception exception) {
            System.out.println("Could not find our own codebase");
            System.exit(1);
        }
    }
}

